/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iDate vec4(0.0,0.0,0.0,iGlobalTime)

/////////////////////////////////////////////////////////////////////////////////

void main(void)
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
     
    
    float lines = atan(uv.y - 0.5,uv.x - 0.1);
    lines += atan(uv.y - 0.75,uv.x - 0.5);
    lines += atan(uv.y + 0.8,uv.x - 0.5);
    lines += atan(uv.x - 0.5,uv.y - 0.5);
    lines += atan(uv.x - 0.8,uv.y - 0.6);
    lines += atan(uv.y - 0.85, 1.0-uv.x - 0.2);
    
    lines /= 5.0;
    
    float allLines = cos((lines + iGlobalTime * 0.5));
    
    uv.y /= (iResolution.x)/iResolution.y;	 
    
    float circs = smoothstep(0.0, 0.5, length(uv - vec2(0.1, 0.25)));
    circs += smoothstep(0.0, 0.2, distance(uv , vec2(0.8, 0.3)));
    
    float c = acos(distance(cos(circs * 1.5), allLines));
    
	gl_FragColor = vec4(c * 0.8,c * 0.9, c,1.0);
}